* THIS IS NOT THE ONLY GHS PREPARATION FILE - further preparation is done in the 'PMS data preparation.do' file (attaching some values from PMS randomly)
* This is copied from the NDNS data preparation, which was the first to be done.  However, daily limits are clearly dropped here.
* All variables created are coded with a letter (a, b etc) and also 'l' or 'h', to show whether low or high


/* Initial use of 2002/3 data, later rejected
	cd "Z:\IAS STATA files\GHS 2002-3\stata8"
	use ghs02client.dta, replace
	keep persno age sex weight02 selfcom2-dramount country nbl7unit-l7drdys2 nbunits-alcwkg3 		*/


cd "Z:\IAS STATA files\GHS 2000-1\stata8"
use ghs00client1.dta
move selfcom2 drinknow		//	Moves self-completion check in front of the first alcohol q
move selfcom2 drinknow		//  	Needs to be in twice for some reason
keep persno hserial schedtyp govreggb sampyear sex age weight00 selfcom2-qfrating
mvdecode drating, mv (-6 -8 -9)
save working, replace

global age "age"				// So that adapting this to other datasets is faster...
global sex "sex"				// Assumes 1 is male and 2 is female, as per statistical convention
global units "drating"


*****************************************************
* uni_ch - WEEKLY LIMITS: 21 units for men, 14 for women 
*****************************************************
quietly {
	capture drop uni_ch*
	gen double uni_chtot = $units
	replace uni_chtot = 21 if ($units>21 & $sex==1)
	replace uni_chtot = 14 if ($units>14 & $sex==2)
	recode uni_chtot (nonmiss=.) if $units==.
	label var uni_chtot "WEEKLY LIMITS: 21(m) 14(f)"
	}
sum $units uni_chtot // [fweight=diarywgt] doesn't work - can't use pweights, need to create a fweight


*****************************************************
* uni_cl - WEEKLY LIMITS: 28 units for men, 21 for women 
*****************************************************
quietly {
	capture drop uni_cl*
	gen double uni_cltot = $units
	replace uni_cltot = 28 if ($units>28 & $sex==1)
	replace uni_cltot = 21 if ($units>21 & $sex==2)
	recode uni_cltot (nonmiss=.) if $units==.
	label var uni_cltot "WEEKLY LIMITS: 28(m) 21(f)"
	}
sum $units uni_cltot // [fweight=diarywgt] doesn't work - can't use pweights, need to create a fweight


*******************************************************
* uni_d - AGE-DISAGRREGATED NADIR: as per White
*******************************************************
* quietly {
	capture drop uni_d*
	gen double uni_dtot = $units
	replace uni_dtot = 0   if ($units>0    & $sex==1 & $age>=19 & $age<=24)
	replace uni_dtot = 0.1 if ($units>0.1  & $sex==1 & $age>=25 & $age<=34)
	replace uni_dtot = 1.8 if ($units>1.8  & $sex==1 & $age>=35 & $age<=44)
	replace uni_dtot = 5.1 if ($units>5.1  & $sex==1 & $age>=45 & $age<=54)
	replace uni_dtot = 7.2 if ($units>7.2  & $sex==1 & $age>=55 & $age<=64)
	replace uni_dtot = 7.2 if ($units>8.4  & $sex==1 & $age>=65 & $age<=74)
	replace uni_dtot = 7.2 if ($units>8.0  & $sex==1 & $age>=75 & $age<=84)
	replace uni_dtot = 7.2 if ($units>7.7  & $sex==1 & $age>=85)


	replace uni_dtot = 0   if ($units>0    & $sex==2 & $age>=19 & $age<=34)
	replace uni_dtot = 0.2 if ($units>0.2  & $sex==2 & $age>=35 & $age<=44)
	replace uni_dtot = 0.5 if ($units>0.5  & $sex==2 & $age>=45 & $age<=54)
	replace uni_dtot = 1.6 if ($units>1.6  & $sex==2 & $age>=55 & $age<=64)
	replace uni_dtot = 2.7 if ($units>2.7  & $sex==2 & $age>=65 & $age<=74)
	replace uni_dtot = 3.2 if ($units>3.2  & $sex==2 & $age>=75 & $age<=84)
	replace uni_dtot = 3.1 if ($units>3.1  & $sex==2 & $age>=85)

	recode uni_dtot (*=.) if $units==.
	label var uni_dtot "AGE DISAGGREGATED NADIR - White 2002"
*	}
sum $units uni_dtot // [fweight=diarywgt] doesn't work - can't use pweights, need to create a fweight





******************************************************************************************************************************************************
******************************************************************************************************************************************************
**** IF EXCLUDE ALL CONS   ***************************************************************************************************************************
******************************************************************************************************************************************************
******************************************************************************************************************************************************



***************************************************
* uni0ch - WEEKLY LIMITS: 21 units for men, 14 for women 
*****************************************************
quietly {
	capture drop uni0ch*
	gen double uni0chtot = $units
	replace uni0chtot = 0 if ($units>21 & $sex==1)
	replace uni0chtot = 0 if ($units>14 & $sex==2)
	recode uni0chtot (nonmiss=.) if $units==.
	label var uni0chtot "WEEKLY LIMITS & SET TO 0: 21(m) 14(f)"
	}
sum $units uni0chtot // [fweight=diarywgt] doesn't work - can't use pweights, need to create a fweight


*****************************************************
* uni0cl - WEEKLY LIMITS: 28 units for men, 21 for women 
*****************************************************
quietly {
	capture drop uni0cl*
	gen double uni0cltot = $units
	replace uni0cltot = 0 if ($units>28 & $sex==1)
	replace uni0cltot = 0 if ($units>21 & $sex==2)
	recode uni0cltot (nonmiss=.) if $units==.
	label var uni0cltot "WEEKLY LIMITS & SET TO 0: 28(m) 21(f)"
	}
sum $units uni0cltot // [fweight=diarywgt] doesn't work - can't use pweights, need to create a fweight


*******************************************************
* uni0d - AGE-DISAGRREGATED NADIR: as per White
*******************************************************
* quietly {
	capture drop uni0d*
	gen double uni0dtot = $units
	replace uni0dtot = 0 if ($units>0    & $sex==1 & $age>=19 & $age<=24)
	replace uni0dtot = 0 if ($units>0.1  & $sex==1 & $age>=25 & $age<=34)
	replace uni0dtot = 0 if ($units>1.8  & $sex==1 & $age>=35 & $age<=44)
	replace uni0dtot = 0 if ($units>5.1  & $sex==1 & $age>=45 & $age<=54)
	replace uni0dtot = 0 if ($units>7.2  & $sex==1 & $age>=55 & $age<=64)
	replace uni0dtot = 0 if ($units>8.4  & $sex==1 & $age>=65 & $age<=74)
	replace uni0dtot = 0 if ($units>8.0  & $sex==1 & $age>=75 & $age<=84)
	replace uni0dtot = 0 if ($units>7.7  & $sex==1 & $age>=85)


	replace uni0dtot = 0   if ($units>0    & $sex==2 & $age>=19 & $age<=34)
	replace uni0dtot = 0 if ($units>0.2  & $sex==2 & $age>=35 & $age<=44)
	replace uni0dtot = 0 if ($units>0.5  & $sex==2 & $age>=45 & $age<=54)
	replace uni0dtot = 0 if ($units>1.6  & $sex==2 & $age>=55 & $age<=64)
	replace uni0dtot = 0 if ($units>2.7  & $sex==2 & $age>=65 & $age<=74)
	replace uni0dtot = 0 if ($units>3.2  & $sex==2 & $age>=75 & $age<=84)
	replace uni0dtot = 0 if ($units>3.1  & $sex==2 & $age>=85)

	recode uni0dtot (*=.) if $units==.
	label var uni0dtot "AGE DISAGGREGATED NADIR & SET TO ZERO"
*	}
sum $units uni0dtot // [fweight=diarywgt] doesn't work - can't use pweights, need to create a fweight








******************************************************************************************************************************************************
******************************************************************************************************************************************************
**** IF ADD ON MODERATE DRINKING**********************************************************************************************************************
******************************************************************************************************************************************************
******************************************************************************************************************************************************


*****************************************************
* muni_ch - WEEKLY LIMITS: 21 units for men, 14 for women 
*****************************************************
quietly {
	capture drop muni_ch*
	gen double muni_chtot = $units
	replace muni_chtot = 21 if ($units<21 & $sex==1)
	replace muni_chtot = 14 if ($units<14 & $sex==2)
	recode muni_chtot (nonmiss=.) if $units==.
	label var muni_chtot "RAISED TO WEEKLY LIMITS: 21(m) 14(f)"
	}
sum $units muni_chtot // [fweight=diarywgt] doesn't work - can't use pweights, need to create a fweight


*****************************************************
* muni_cl - WEEKLY LIMITS: 28 units for men, 21 for women 
*****************************************************
quietly {
	capture drop muni_cl*
	gen double muni_cltot = $units
	replace muni_cltot = 28 if ($units<28 & $sex==1)
	replace muni_cltot = 21 if ($units<21 & $sex==2)
	recode muni_cltot (nonmiss=.) if $units==.
	label var muni_cltot "RAISED TO WEEKLY LIMITS: 28(m) 21(f)"
	}
sum $units muni_cltot // [fweight=diarywgt] doesn't work - can't use pweights, need to create a fweight


*******************************************************
* muni_d - AGE-DISAGRREGATED NADIR: as per White
*******************************************************
* quietly {
	capture drop muni_d*
	gen double muni_dtot = $units
	replace muni_dtot = 0   if ($units==0    & $sex==1 & $age>=19 & $age<=24)
	replace muni_dtot = 0.1 if ($units<0.1  & $sex==1 & $age>=25 & $age<=34)
	replace muni_dtot = 1.8 if ($units<1.8  & $sex==1 & $age>=35 & $age<=44)
	replace muni_dtot = 5.1 if ($units<5.1  & $sex==1 & $age>=45 & $age<=54)
	replace muni_dtot = 7.2 if ($units<7.2  & $sex==1 & $age>=55 & $age<=64)
	replace muni_dtot = 7.2 if ($units<8.4  & $sex==1 & $age>=65 & $age<=74)
	replace muni_dtot = 7.2 if ($units<8.0  & $sex==1 & $age>=75 & $age<=84)
	replace muni_dtot = 7.2 if ($units<7.7  & $sex==1 & $age>=85)


	replace muni_dtot = 0   if ($units==0    & $sex==2 & $age>=19 & $age<=34)
	replace muni_dtot = 0.2 if ($units<0.2  & $sex==2 & $age>=35 & $age<=44)
	replace muni_dtot = 0.5 if ($units<0.5  & $sex==2 & $age>=45 & $age<=54)
	replace muni_dtot = 1.6 if ($units<1.6  & $sex==2 & $age>=55 & $age<=64)
	replace muni_dtot = 2.7 if ($units<2.7  & $sex==2 & $age>=65 & $age<=74)
	replace muni_dtot = 3.2 if ($units<3.2  & $sex==2 & $age>=75 & $age<=84)
	replace muni_dtot = 3.1 if ($units<3.1  & $sex==2 & $age>=85)

	recode muni_dtot (*=.) if $units==.
	label var muni_dtot "RAISED TO White NADIR"
*	}
sum $units muni_dtot // [fweight=diarywgt] doesn't work - can't use pweights, need to create a fweight




******************************************************************************************************************************************************
******************************************************************************************************************************************************
**** IF ADD ON MODERATE DRINKING AFTER TAKING OFF UNHEALTHY DRINKING    ******************************************************************************
******************************************************************************************************************************************************
******************************************************************************************************************************************************


*****************************************************
* muni_ch - WEEKLY LIMITS: 21 units for men, 14 for women 
*****************************************************
quietly {
	capture drop muni0ch*
	gen double muni0chtot = uni0chtot
	replace muni0chtot = 21 if (uni0chtot<21 & $sex==1)
	replace muni0chtot = 14 if (uni0chtot<14 & $sex==2)
	recode muni0chtot (nonmiss=.) if $units==.
	label var muni0chtot "RAISED AND LOWERED TO WK: 21(m) 14(f)"
	}
sum $units muni0chtot 


*****************************************************
* muni_cl - WEEKLY LIMITS: 28 units for men, 21 for women 
*****************************************************
quietly {
	capture drop muni0cl*
	gen double muni0cltot = uni0cltot
	replace muni0cltot = 28 if (uni0cltot<28 & $sex==1)
	replace muni0cltot = 21 if (uni0cltot<21 & $sex==2)
	recode muni0cltot (nonmiss=.) if $units==.
	label var muni0cltot "RAISED AND LOWERED TO WK: 28(m) 21(f)"
	}
sum $units uni0cltot 


*******************************************************
* muni_d - AGE-DISAGRREGATED NADIR: as per White
*******************************************************
* quietly {
	capture drop muni0d*
	gen double muni0dtot = uni0dtot
	replace muni0dtot = 0   if (uni0dtot==0    & $sex==1 & $age>=19 & $age<=24)
	replace muni0dtot = 0.1 if (uni0dtot<0.1  & $sex==1 & $age>=25 & $age<=34)
	replace muni0dtot = 1.8 if (uni0dtot<1.8  & $sex==1 & $age>=35 & $age<=44)
	replace muni0dtot = 5.1 if (uni0dtot<5.1  & $sex==1 & $age>=45 & $age<=54)
	replace muni0dtot = 7.2 if (uni0dtot<7.2  & $sex==1 & $age>=55 & $age<=64)
	replace muni0dtot = 7.2 if (uni0dtot<8.4  & $sex==1 & $age>=65 & $age<=74)
	replace muni0dtot = 7.2 if (uni0dtot<8.0  & $sex==1 & $age>=75 & $age<=84)
	replace muni0dtot = 7.2 if (uni0dtot<7.7  & $sex==1 & $age>=85)


	replace muni0dtot = 0   if (uni0dtot==0    & $sex==2 & $age>=19 & $age<=34)
	replace muni0dtot = 0.2 if (uni0dtot<0.2  & $sex==2 & $age>=35 & $age<=44)
	replace muni0dtot = 0.5 if (uni0dtot<0.5  & $sex==2 & $age>=45 & $age<=54)
	replace muni0dtot = 1.6 if (uni0dtot<1.6  & $sex==2 & $age>=55 & $age<=64)
	replace muni0dtot = 2.7 if (uni0dtot<2.7  & $sex==2 & $age>=65 & $age<=74)
	replace muni0dtot = 3.2 if (uni0dtot<3.2  & $sex==2 & $age>=75 & $age<=84)
	replace muni0dtot = 3.1 if (uni0dtot<3.1  & $sex==2 & $age>=85)

	recode muni0dtot (*=.) if uni0dtot==.
	label var muni0dtot "RAISED AND LOWERED TO White NADIR"
*	}
sum $units muni0dtot 



******************************************************************************************************************************************************
******************************************************************************************************************************************************
**** IF ADD ON MODERATE DRINKING for drinkers only ***************************************************************************************************
******************************************************************************************************************************************************
******************************************************************************************************************************************************


*****************************************************
* nuni_ch - WEEKLY LIMITS: 21 units for men, 14 for women 
*****************************************************
quietly {
	capture drop nuni_ch*
	gen double nuni_chtot = $units
	replace nuni_chtot = 21 if ($units<21 & $units>0 & $sex==1)
	replace nuni_chtot = 14 if ($units<14 & $units>0 & $sex==2)
	recode nuni_chtot (nonmiss=.) if $units==.
	label var nuni_chtot "Drinkers RAISED TO WEEKLY LIMITS: 21(m) 14(f)"
	}
sum $units nuni_chtot // [fweight=diarywgt] doesn't work - can't use pweights, need to create a fweight


*****************************************************
* nuni_cl - WEEKLY LIMITS: 28 units for men, 21 for women 
*****************************************************
quietly {
	capture drop nuni_cl*
	gen double nuni_cltot = $units
	replace nuni_cltot = 28 if ($units<28 & $units>0 & $sex==1)
	replace nuni_cltot = 21 if ($units<21 & $units>0 & $sex==2)
	recode nuni_cltot (nonmiss=.) if $units==.
	label var nuni_cltot "Drinkers RAISED TO WEEKLY LIMITS: 28(m) 21(f)"
	}
sum $units nuni_cltot // [fweight=diarywgt] doesn't work - can't use pweights, need to create a fweight


*******************************************************
* nuni_d - AGE-DISAGRREGATED NADIR: as per White
*******************************************************
* quietly {
	capture drop nuni_d*
	gen double nuni_dtot = $units
	replace nuni_dtot = 0   if ($units==0    & $sex==1 & $age>=19 & $age<=24)
	replace nuni_dtot = 0.1 if ($units<0.1  & $units>0 & $sex==1 & $age>=25 & $age<=34)
	replace nuni_dtot = 1.8 if ($units<1.8  & $units>0 & $sex==1 & $age>=35 & $age<=44)
	replace nuni_dtot = 5.1 if ($units<5.1  & $units>0 & $sex==1 & $age>=45 & $age<=54)
	replace nuni_dtot = 7.2 if ($units<7.2  & $units>0 & $sex==1 & $age>=55 & $age<=64)
	replace nuni_dtot = 7.2 if ($units<8.4  & $units>0 & $sex==1 & $age>=65 & $age<=74)
	replace nuni_dtot = 7.2 if ($units<8.0  & $units>0 & $sex==1 & $age>=75 & $age<=84)
	replace nuni_dtot = 7.2 if ($units<7.7  & $units>0 & $sex==1 & $age>=85)


	replace nuni_dtot = 0   if ($units==0    & $sex==2 & $age>=19 & $age<=34)
	replace nuni_dtot = 0.2 if ($units<0.2  & $units>0 & $sex==2 & $age>=35 & $age<=44)
	replace nuni_dtot = 0.5 if ($units<0.5  & $units>0 & $sex==2 & $age>=45 & $age<=54)
	replace nuni_dtot = 1.6 if ($units<1.6  & $units>0 & $sex==2 & $age>=55 & $age<=64)
	replace nuni_dtot = 2.7 if ($units<2.7  & $units>0 & $sex==2 & $age>=65 & $age<=74)
	replace nuni_dtot = 3.2 if ($units<3.2  & $units>0 & $sex==2 & $age>=75 & $age<=84)
	replace nuni_dtot = 3.1 if ($units<3.1  & $units>0 & $sex==2 & $age>=85)

	recode nuni_dtot (*=.) if $units==.
	label var nuni_dtot "Drinkers RAISED TO White NADIR"
*	}
sum $units nuni_dtot // [fweight=diarywgt] doesn't work - can't use pweights, need to create a fweight




******************************************************************************************************************************************************
******************************************************************************************************************************************************
**** IF ADD ON MODERATE DRINKING AFTER TAKING OFF UNHEALTHY DRINKING for drinkers only ***************************************************************
******************************************************************************************************************************************************
******************************************************************************************************************************************************


*****************************************************
* nuni_ch - WEEKLY LIMITS: 21 units for men, 14 for women 
*****************************************************
quietly {
	capture drop nuni0ch*
	gen double nuni0chtot = uni0chtot
	replace nuni0chtot = 21 if (uni0chtot<21 & uni0chtot>0 & $sex==1)
	replace nuni0chtot = 14 if (uni0chtot<14 & uni0chtot>0 & $sex==2)
	recode nuni0chtot (nonmiss=.) if $units==.
	label var nuni0chtot "Drinkers RAISED & LOWERED TO WK: 21(m) 14(f)"
	}
sum $units nuni0chtot 


*****************************************************
* nuni_cl - WEEKLY LIMITS: 28 units for men, 21 for women 
*****************************************************
quietly {
	capture drop nuni0cl*
	gen double nuni0cltot = uni0cltot
	replace nuni0cltot = 28 if (uni0cltot<28 & uni0cltot>0 & $sex==1)
	replace nuni0cltot = 21 if (uni0cltot<21 & uni0cltot>0 & $sex==2)
	recode nuni0cltot (nonmiss=.) if $units==.
	label var nuni0cltot "Drinkers RAISED & LOWERED TO WK: 28(m) 21(f)"
	}
sum $units uni0cltot 


*******************************************************
* nuni_d - AGE-DISAGRREGATED NADIR: as per White
*******************************************************
* quietly {
	capture drop nuni0d*
	gen double nuni0dtot = uni0dtot
	replace nuni0dtot = 0   if (uni0dtot==0   & $sex==1 & $age>=19 & $age<=24)
	replace nuni0dtot = 0.1 if (uni0dtot<0.1  & uni0dtot>0 & $sex==1 & $age>=25 & $age<=34)
	replace nuni0dtot = 1.8 if (uni0dtot<1.8  & uni0dtot>0 & $sex==1 & $age>=35 & $age<=44)
	replace nuni0dtot = 5.1 if (uni0dtot<5.1  & uni0dtot>0 & $sex==1 & $age>=45 & $age<=54)
	replace nuni0dtot = 7.2 if (uni0dtot<7.2  & uni0dtot>0 & $sex==1 & $age>=55 & $age<=64)
	replace nuni0dtot = 7.2 if (uni0dtot<8.4  & uni0dtot>0 & $sex==1 & $age>=65 & $age<=74)
	replace nuni0dtot = 7.2 if (uni0dtot<8.0  & uni0dtot>0 & $sex==1 & $age>=75 & $age<=84)
	replace nuni0dtot = 7.2 if (uni0dtot<7.7  & uni0dtot>0 & $sex==1 & $age>=85)


	replace nuni0dtot = 0   if (uni0dtot==0    & $sex==2 & $age>=19 & $age<=34)
	replace nuni0dtot = 0.2 if (uni0dtot<0.2  & uni0dtot>0 & $sex==2 & $age>=35 & $age<=44)
	replace nuni0dtot = 0.5 if (uni0dtot<0.5  & uni0dtot>0 & $sex==2 & $age>=45 & $age<=54)
	replace nuni0dtot = 1.6 if (uni0dtot<1.6  & uni0dtot>0 & $sex==2 & $age>=55 & $age<=64)
	replace nuni0dtot = 2.7 if (uni0dtot<2.7  & uni0dtot>0 & $sex==2 & $age>=65 & $age<=74)
	replace nuni0dtot = 3.2 if (uni0dtot<3.2  & uni0dtot>0 & $sex==2 & $age>=75 & $age<=84)
	replace nuni0dtot = 3.1 if (uni0dtot<3.1  & uni0dtot>0 & $sex==2 & $age>=85)

	recode nuni0dtot (*=.) if uni0dtot==.
	label var nuni0dtot "Drinkers RAISED & LOWERED TO White NADIR"
*	}
sum $units nuni0dtot 



save working, replace